package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="requestparticipantdocument", schema="hib")
public class RequestParticipantDocument {
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	private int id;
	
	@Column(name="requestid")
	private int requestId;
	
	@Column(name="participantid")
	private int participantId;
	
	@Column(name="documentid")
	private int documentId;

	@Column(name="active", columnDefinition = "BIT", length = 1)
	private boolean active;

	RequestParticipantDocument() {} 
	
	public static RequestParticipantDocument create(Request request, Participant participant, Document document) throws ValidationException {
		ValidationHelper.required("Request", request);
		ValidationHelper.required("Participant", participant);
		ValidationHelper.required("Document", document);
	
		RequestParticipantDocument result = new RequestParticipantDocument();
		result.requestId = request.getId();
		result.participantId = participant.getId();
		result.documentId = document.getId();
		result.active = true;
		
		DartObjectFactory.getInstance().getRequestParticipantDocumentDAO().save(result);
		return result;
	}
	
	
	public static List<RequestParticipantDocument> listByRequestId(final int requestId) {
		return DartObjectFactory.getInstance().getRequestParticipantDocumentDAO().listByRequestId(requestId);
	}

	public static List<RequestParticipantDocument> listByRequestAndParticipantId(final int requestId, final int participantId) {
		return DartObjectFactory.getInstance().getRequestParticipantDocumentDAO().listByRequestAndParticipantId(requestId, participantId);
	}
	
	public static List<RequestParticipantDocument> listActiveDocsByRequestAndParticipantId(final int requestId, final int participantId) {
		return DartObjectFactory.getInstance().getRequestParticipantDocumentDAO().listActiveDocsByRequestAndParticipantId(requestId, participantId);
	}
	
	public void delete() {
		DartObjectFactory.getInstance().getRequestParticipantDocumentDAO().delete(this);
	}
	
	public int getId() {
		return id;
	}
	
	// TESTING ONLY
	public void setId(int id) {
		this.id = id;
	}
	
	public int getRequestId() {
		return requestId;
	}

	public int getParticipantId() {
		return participantId;
	}

	public int getDocumentId() {
		return documentId;
	}
	
	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
}
